/** @file   AnimFrame.cpp
 * @brief   Implementation of AnimFrame class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:39 $
 * @author  Tomi Lamminsaari
 */

#include "AnimFrame.h"


namespace eng2d {
  

///
/// Constants, datatypes and static methods
/// ============================================================================




///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
AnimFrame::AnimFrame() :
  iFrameIndex( -1 ),
  iFrameDelay( 1 ),
  iFrameSound( -1 ),
  iFrameBlend( ESolid ),
  iFrameAlpha( 128 ),
  iGfx( 0 ),
  iGfxType( EUnspecified )
{
}



/** Constructor.
 */
AnimFrame::AnimFrame( int aIndex, int aDelay ) :
  iFrameIndex( aIndex ),
  iFrameDelay( aDelay ),
  iFrameSound( -1 ),
  iFrameBlend( ESolid ),
  iFrameAlpha( 128 ),
  iGfx( 0 ),
  iGfxType( EUnspecified )
{
}



/** Destructor.
 */
AnimFrame::~AnimFrame()
{
}





///
/// Methods inhertited from the base class(es)
/// ============================================================================




///
/// New public methods
/// ============================================================================

/** Sets the graphics.
 */
void AnimFrame::setGraphics( GfxContentType aType, void* aGfx )
{
  iGfx = aGfx;
  iGfxType = aType;
}



/** Reads the data from given stream.
 */
int AnimFrame::read( std::istream& aIn )
{
  while ( aIn.eof() == false ) {
    std::string tmp;
    aIn >> tmp;
    if ( tmp == "#" ) {
       aIn.ignore(4096, '\n');
      
    } else if ( tmp == "</f>" ) {
      return KErrNone;
      
    } else if ( tmp == "fid:" ) {
      if ( aIn.eof() ) return KErrEof;
      aIn >> tmp;
      iFrameIndex = atoi( tmp.c_str() );
      
    } else if ( tmp == "delay:" ) {
      if ( aIn.eof() ) return KErrEof;
      aIn >> tmp;
      iFrameDelay = atoi( tmp.c_str() );
      
    } else if ( tmp == "sound:" ) {
      if ( aIn.eof() ) return KErrEof;
      aIn >> tmp;
      iFrameSound = atoi( tmp.c_str() );
      
    } else if ( tmp == "blend:" ) {
      if ( aIn.eof() ) return KErrEof;
      aIn >> tmp;
      iFrameBlend = String2BlendMode( tmp );
      
    } else if ( tmp == "opa:" ) {
      if ( aIn.eof() ) return KErrEof;
      aIn >> tmp;
      iFrameAlpha = atoi( tmp.c_str() );
      
    } else {
      return KErrNotSupported;
      
    }
  }
  return KErrEof;
}




///
/// Getter methods
/// ============================================================================

/** Returns a BITMAP pointer
 */
BITMAP* AnimFrame::asBitmap() const
{
  if ( iGfxType != EBitmap ) return 0;
  return reinterpret_cast<BITMAP*>( iGfx );
}



/** Returns a RLE_SPRITE pointer
 */
RLE_SPRITE* AnimFrame::asRleSprite() const
{
  if ( iGfxType != ERleSprite ) return 0;
  return reinterpret_cast<RLE_SPRITE*>( iGfx );
}



/** Returns the graphics content type.
 */
GfxContentType AnimFrame::gfxType() const
{
  return iGfxType;
}




///
/// Protected and private methods
/// ============================================================================



}
